//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for ASUSTeK Computers
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//  Last Update: 07 December 2010
//
public static class ASUSTEK
{

    #region Notebook ASUS M2N : class M2N
    //
    // class author: NHC
    //
    public class M2N
    {
        public static string author = "Manfred Jaider";                             // The author of the class

        #region LCD Brightness Status : class BRIGHTNESS_STATUS
        //
        public class BRIGHTNESS_STATUS
        {
            // Properties of this section class
            public const string description = "LCD Brightness Status";              // Description for the class
            public const string tooltip = description;                              // Tooltip for the class (optimal)
            public const int icon = 15;                                             // Icon for the class (use the ACPI Class Editor to see all available icons)
            public static bool nhc_visible = true;                                  // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
            public const bool default_enabled = true;                               // If true the class is enabled in NHC by default (optional)

            #region Value class CURRENT_BRIGHTNESS : class CURRENT_BRIGHTNESS
            //
            public class CURRENT_BRIGHTNESS
            {
                // Properties of this value class
                public const string description = "Current brightness level";       // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 1;                                          // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int current_brightness = 0;                           // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.
            }
            //
            #endregion

            #region nhcFunction: refresh()
            //
            // NHC will call this optional function with the time interval of refresh_interval
            //
            public const int refresh_interval = 1;                                  // refresh interval in seconds
            public const bool simple_refresh = true;                                // if true NHC will call the refresh function only if this class is visible on the user surface
            public static bool refresh()
            {
                int register_brightness_value = 0;
                if (ACPI.METHOD.GetValue("_SB.ATKD.GPLV", ref register_brightness_value) == true)                   // get the brightness level
                {
                    CURRENT_BRIGHTNESS.current_brightness = brightness_to_percent(register_brightness_value);       // convert "register brightness value" to "percent brightness value"
                    return true;
                }
                else
                {
                    return false;
                }
            }
            //
            #endregion

            #region brightness_to_percent(), percent_to_brightness()
            //
            //  min register brightness value: 0 (0%)
            //  max register brightness value: 15 (100%)
            //  100 / 15 = 6.666
            //
            public static int percent_to_brightness(double value)
            {
                value = (double)(value / (double)6.666);
                return (int)System.Math.Round(value, 0);
            }
            public static int brightness_to_percent(double value)
            {
                value = (double)(value * (double)6.666);
                return (int)System.Math.Round(value, 0);
            }
            //
            #endregion
        }
        //
        #endregion

        #region LCD Brightness Control : class BRIGHTNESS_CONTROL
        //
        public class BRIGHTNESS_CONTROL
        {
            // Properties of this section class
            public const string description = "LCD Brightness Control";             // Description for the class
            public const string tooltip = description;                              // Tooltip for the class (optimal)
            public const int icon = 14;                                             // Icon for the class (use the ACPI Class Editor to see all available icons)
            public static bool nhc_visible = true;                                  // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
            public const bool default_enabled = false;                              // If true the class is enabled in NHC by default (optional)

            #region Value class BRIGHTNESS_VALUE : class BRIGHTNESS_VALUE
            //
            public class BRIGHTNESS_VALUE
            {
                // Properties of this value class
                public const string description = "Brightness value";               // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 252;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int brightness_value = 100;                           // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 100;                       // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        int register_brightness_value = BRIGHTNESS_STATUS.percent_to_brightness(brightness_value);          // convert "percent brightness value" to "register brightness value"
                        return ACPI.METHOD.SetValue("_SB.ATKD.SPLV", register_brightness_value);
                    }
                }
                //
                #endregion
            }
            //
            #endregion

        }
        //
        #endregion

        #region Fan Control : class FAN_CONTROL
        //
        public class FAN_CONTROL
        {
            // Properties of this section class
            public const string description = "Fan Control";                        // Description for the class
            public const string tooltip = "Fan Control for Asus M2400N Notebook";   // Tooltip for the class (optimal)
            public const int icon = 2;                                              // Icon for the class (use the ACPI Class Editor to see all available icons)
            public static bool nhc_visible = true;                                  // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
            public const bool default_enabled = false;                               // If true the class is enabled in NHC by default (optional)

            // Condition variables (optimal)
            public static bool initialisation = false;                              // On initialisation NHC will set this variable to true; after the initialisation NHC will set this variable to false (optional)

            #region INFO
            //
            // OperationRegion (\RAMW, SystemMemory, RAMB, 0xFF)
            // Field (\RAMW, ByteAcc, NoLock, Preserve)
            // {
            //     . . .
            //     . . .
            //     Offset (0xBE),
            //     PADL,   16,
            //     CADL,   16,
            //     CSTE,   16,
            //     NSTE,   16,
            //     SSTE,   16,
            //     SFUN,   8,
            //     TSAD,   8,
            //     TAC3,   8,        // 48°C         <- FAN ON low level
            //     TAC2,   8,        // 68°C         <- FAN ON middle level
            //     TAC1,   8,        // 78°C         <- FAN ON high level
            //     TAC0,   8,        // 86°C         <- FAN ON maximum level
            //     TPSV,   8,        // 105°C        <- clock down
            //     TCRT,   8,        // 110°C        <- turn off computer
            //     F1L0,   8,        // 254 -rmp     <- FAN OFF
            //     F2L0,   8,        // 0
            //     F1L1,   8,        // 181 -rmp     <- FAN low speed
            //     F2L1,   8,        // 0
            //     F1L2,   8,        // 149 -rmp     <- FAN middle speed
            //     F2L2,   8,        // 0
            //     F1L3,   8,        // 139 -rmp     <- FAN high speed
            //     F2L3,   8,        // 0
            //     F1L4,   8,        // 112 -rmp     <- FAN maximum speed
            //     F2L4,   8,        // 0
            //     SLPT,   8,
            //     DBRD,   32,
            //     SIDS,   8,
            //     Offset (0xE3),
            //     CPUS,   8
            // }
            //
            #endregion


            #region Value class FAN_VERY_LOW_SPEED : class FAN_VERY_LOW_SPEED
            //
            public class FAN_VERY_LOW_SPEED
            {
                // Properties of this value class
                public const string description = "FAN very low speed";             // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 175;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int fan_very_low_speed = 0;                           // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 0;                         // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (ACPI.FIELD.Write("F1L0", convert_percent_to_fan_speed(fan_very_low_speed)) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class FAN_LOW_SPEED : class FAN_LOW_SPEED
            //
            public class FAN_LOW_SPEED
            {
                // Properties of this value class
                public const string description = "FAN low speed";                  // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 174;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int fan_low_speed = 51;                               // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 51;                        // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (ACPI.FIELD.Write("F1L1", convert_percent_to_fan_speed(fan_low_speed)) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class FAN_MIDDLE_SPEED : class FAN_MIDDLE_SPEED
            //
            public class FAN_MIDDLE_SPEED
            {
                // Properties of this value class
                public const string description = "FAN middle speed";               // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 173;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int fan_middle_speed = 74;                            // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 74;                        // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (ACPI.FIELD.Write("F1L2", convert_percent_to_fan_speed(fan_middle_speed)) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class FAN_HIGH_SPEED : class FAN_HIGH_SPEED
            //
            public class FAN_HIGH_SPEED
            {
                // Properties of this value class
                public const string description = "FAN high speed";                 // Description for the value
                public const string tooltip = description;                          // Tooltip for the value (optimal)
                public const int icon = 172;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int fan_high_speed = 81;                              // It must have the same name as the class (case are ignored)
                public const string unit = "%";                                     // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 100;                       // maximum input value
                    public const int nhc_default_value = 81;                        // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (ACPI.FIELD.Write("F1L3", convert_percent_to_fan_speed(fan_high_speed)) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public class LOW_LEVEL_ON
            {
                // Properties of this value class
                public const string description = "FAN ON low level";               // Description for the value
                public const string tooltip = "FAN ON temperature low level";       // Tooltip for the value (optimal)
                public const int icon = 182;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int low_level_on = 48;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 48;                        // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (ACPI.FIELD.Write("TAC3", low_level_on) == true)         // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public class MIDDLE_LEVEL_ON
            {
                // Properties of this value class
                public const string description = "FAN ON middle level";            // Description for the value
                public const string tooltip = "FAN ON temperature middle level";    // Tooltip for the value (optimal)
                public const int icon = 181;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int middle_level_on = 68;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 68;                        // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (ACPI.FIELD.Write("TAC2", middle_level_on) == true)      // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            #region Value class HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public class HIGH_LEVEL_ON
            {
                // Properties of this value class
                public const string description = "FAN ON high level";              // Description for the value
                public const string tooltip = "FAN ON temperature high level";      // Tooltip for the value (optimal)
                public const int icon = 180;                                        // Icon for the value (use the ACPI Class Editor to see all available icons)
                public static bool nhc_visible = true;                              // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.

                // Value
                public static int high_level_on = 78;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of the value. The value can be masked with the unit string when we use the separator character '|'. Example: The unit string "OFF|ON" will be interpreted as "OFF" for the value 0 and "ON" for the value 1.

                #region NHC_WRITE
                //
                //  With this optional class it is possible to change the value in NHC at runtime
                //
                public class NHC_WRITE
                {
                    public static bool nhc_visible = true;                          // If false the class is not visible in NHC (optional). Modifications at runtime of nhc_visible outside the class constructor are ignored.
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 90;                        // maximum input value
                    public const int nhc_default_value = 78;                        // default value
                    public const int nhc_increment_value = 1;                       // increment/decrement steps of the input value (optimal)
                    public static bool nhc_on_write()                               // optional function - NHC will call this function if the user change the value on runtime and on NHC start
                    {
                        if (ACPI.FIELD.Write("TAC1", high_level_on) == true)        // set the value
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
                //
                #endregion
            }
            //
            #endregion

            //  -   -   -

            #region nhcFunction: init()
            //
            //  NHC will call this optional function on initialisation or if the user enable the class
            //  Note: nhc_write() functions get initialized first
            //
            public static bool init()
            {
                return ACPI.METHOD.Call("_TZ.TCHG");                    // refresh the ThermalZone (Temperature and FAN Speed) on init
            }
            //
            #endregion

            #region refresh_thermal_zone()
            //
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return ACPI.METHOD.Call("_TZ.TCHG");                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                        // on NHC initialisation skip the ThermalZone refresh
                }
            }
            //
            #endregion

            #region convert_fan_speed_to_percent(), convert_percent_to_fan_speed()
            //
            //  min fan speed register value: 254 (0%)
            //  max fan speed register value: 112 (100%)
            //  difference: 254 - 112 = 142
            //
            //  fan low speed: 181 (~51%)
            //  fan middle speed: 149 (74%)
            //  fan high speed: 139 (81%)
            //
            private static int convert_fan_speed_to_percent(double value)
            {
                // percent = ((254 - fan_speed) / 142) * 100
                value = (double)((((double)254 - value) / (double)142) * (double)100);
                return (int)System.Math.Round(value, 0);
            }
            private static int convert_percent_to_fan_speed(double value)
            {
                // fan_speed = 254 - ((percent / 100) * 142)
                value = (double)(((double)value / (double)100) * (double)142);
                int ivalue = (int)System.Math.Round(value, 0);
                return (int)(254 - ivalue);
            }
            //
            #endregion
        }
        //
        #endregion

    }
    //
    #endregion

}

